/*
 * Decompiled with CFR 0.152.
 */
package club.sk1er.autogg.listener;

import club.sk1er.autogg.AutoGG;
import club.sk1er.autogg.config.AutoGGConfig;
import club.sk1er.mods.core.universal.ChatColor;
import club.sk1er.mods.core.util.MinecraftUtils;
import club.sk1er.mods.core.util.Multithreading;
import club.sk1er.vigilance.data.Property;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import net.minecraft.client.Minecraft;
import net.minecraft.util.EnumChatFormatting;
import net.minecraftforge.client.event.ClientChatReceivedEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.FMLNetworkEvent;

public class AutoGGListener {
    private boolean invoked;
    private boolean deferGG;
    private boolean useDelay;
    private boolean mineplex;
    private final Pattern mineplexPattern = Pattern.compile("^(?:us|eu\\.)?mineplex\\.com$");

    @SubscribeEvent
    public void switchTriggersetWrapper(FMLNetworkEvent.ClientConnectedToServerEvent event) {
        AutoGGListener.switchTriggerset();
    }

    @SubscribeEvent
    public void worldSwap(WorldEvent.Load event) {
        this.invoked = false;
        Multithreading.schedule(() -> {
            String scoreboardTitle;
            this.mineplex = this.mineplexPattern.matcher(AutoGG.getServerIP()).matches();
            try {
                scoreboardTitle = EnumChatFormatting.func_110646_a((String)event.world.func_96441_U().func_96539_a(1).func_96678_d());
            }
            catch (Exception e) {
                this.end();
                this.useDelay = false;
                this.deferGG = false;
                return;
            }
            this.deferGG = "HOLE IN THE WALL".equals(scoreboardTitle) || "CAPTURE THE WOOL".equals(scoreboardTitle);
            this.useDelay = "SPEED UHC".equals(scoreboardTitle) || "PIXEL PAINTERS".equals(scoreboardTitle);
            this.end();
        }, (long)300L, (TimeUnit)TimeUnit.MILLISECONDS);
    }

    @SubscribeEvent
    public void onChat(ClientChatReceivedEvent event) {
        String unformattedText = EnumChatFormatting.func_110646_a((String)event.message.func_150260_c());
        if (AutoGG.instance.getAutoGGConfig().isAntiKarmaEnabled() && AutoGG.otherRegexes.get("anti_karma").matcher(unformattedText).matches()) {
            event.setCanceled(true);
            return;
        }
        if (this.invoked && AutoGG.instance.getAutoGGConfig().isAntiGGEnabled() && AutoGG.otherRegexes.get("antigg").matcher(unformattedText).matches()) {
            event.setCanceled(true);
            return;
        }
        if (!AutoGG.instance.isRunning()) {
            if (AutoGG.instance.getAutoGGConfig().isCasualAutoGGEnabled()) {
                for (Pattern trigger : AutoGG.ggRegexes.get("casual_triggers")) {
                    if (!trigger.matcher(unformattedText).matches()) continue;
                    AutoGG.instance.setRunning(true);
                    this.invoked = true;
                    this.sayGG(false, 0);
                    AutoGG.instance.setRunning(false);
                    Multithreading.schedule(() -> {
                        this.invoked = false;
                        this.end();
                    }, (long)60L, (TimeUnit)TimeUnit.SECONDS);
                    return;
                }
            }
            if (AutoGG.instance.getAutoGGConfig().isAutoGGEnabled()) {
                for (Pattern trigger : AutoGG.ggRegexes.get("triggers")) {
                    if (!trigger.matcher(unformattedText).matches()) continue;
                    if (this.deferGG) {
                        this.deferGG = false;
                        return;
                    }
                    AutoGG.instance.setRunning(true);
                    this.invoked = true;
                    this.sayGG(true, this.useDelay ? 240 : 0);
                    return;
                }
            }
        }
    }

    private void sayGG(boolean doSecond, int addedTime) {
        Multithreading.schedule(() -> {
            try {
                Minecraft.func_71410_x().field_71439_g.func_71165_d(AutoGG.other.get("msg") + this.getPrimaryString());
                if (AutoGG.instance.getAutoGGConfig().isSecondaryEnabled() && doSecond) {
                    Multithreading.schedule(() -> {
                        try {
                            Minecraft.func_71410_x().field_71439_g.func_71165_d(AutoGG.other.get("msg") + this.getSecondString());
                        }
                        catch (RuntimeException e) {
                            MinecraftUtils.sendMessage((String)AutoGG.instance.getPrefix(), (String)(ChatColor.RED + "An error occurred getting secondary string. Check logs for more information."));
                            AutoGG.instance.getLogger().error("Failed to get secondary string.", (Throwable)e);
                        }
                        finally {
                            this.end();
                        }
                    }, (long)(AutoGG.instance.getAutoGGConfig().getSecondaryDelay() + 10 + (this.mineplex ? 590 : 0)), (TimeUnit)TimeUnit.MILLISECONDS);
                }
            }
            catch (RuntimeException e) {
                MinecraftUtils.sendMessage((String)AutoGG.instance.getPrefix(), (String)(ChatColor.RED + "An error occurred getting primary string. Check logs for more information."));
                AutoGG.instance.getLogger().error("Failed to get primary string.", (Throwable)e);
            }
            catch (Exception e) {
                AutoGG.instance.getLogger().error("Failed to send AutoGG messages.", (Throwable)e);
            }
            finally {
                this.end();
            }
        }, (long)(AutoGG.instance.getAutoGGConfig().getAutoGGDelay() + addedTime + (this.mineplex ? 3000 : 0)), (TimeUnit)TimeUnit.MILLISECONDS);
    }

    public static void switchTriggerset() {
        AutoGG.instance.getDataFromDownloadedTriggers();
        Multithreading.schedule(() -> {
            if (!AutoGG.instance.works()) {
                MinecraftUtils.sendMessage((String)AutoGG.instance.getPrefix(), (String)(ChatColor.RED + "" + ChatColor.BOLD + (!AutoGG.validConfigVersion ? "WARNING! Unsupported AutoGG version! Please update AutoGG or it will not work!" : "Warning! Failed fetching triggers! Check your internet connection, and try running /autogg refresh")));
            }
        }, (long)300L, (TimeUnit)TimeUnit.MILLISECONDS);
    }

    private void end() {
        try {
            Thread.sleep(2000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        AutoGG.instance.setRunning(false);
    }

    public static String[] getPrimaryStrings() {
        try {
            Property autoGGPhrase = AutoGGConfig.class.getDeclaredField("autoGGPhrase").getAnnotation(Property.class);
            ArrayList<String> options = new ArrayList<String>(Arrays.asList(autoGGPhrase.options()));
            return options.toArray(new String[0]);
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
            return new String[0];
        }
    }

    private String getPrimaryString() throws RuntimeException {
        int autoGGPhrase = AutoGG.instance.getAutoGGConfig().getAutoGGPhrase();
        String[] primaryStrings = AutoGGListener.getPrimaryStrings();
        if (autoGGPhrase >= 0 && autoGGPhrase < primaryStrings.length) {
            return primaryStrings[autoGGPhrase];
        }
        throw new RuntimeException("An unknown error occurred parsing config. Try deleting .minecraft/config/autogg.toml or contacting the mod authors.");
    }

    public static String[] getSecondaryStrings() {
        try {
            Property autoGGPhrase = AutoGGConfig.class.getDeclaredField("autoGGPhrase2").getAnnotation(Property.class);
            ArrayList<String> options = new ArrayList<String>(Arrays.asList(autoGGPhrase.options()));
            return options.toArray(new String[0]);
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
            return new String[0];
        }
    }

    private String getSecondString() throws RuntimeException {
        int autoGGPhrase = AutoGG.instance.getAutoGGConfig().getAutoGGPhrase2();
        String[] primaryStrings = AutoGGListener.getSecondaryStrings();
        if (autoGGPhrase >= 0 && autoGGPhrase < primaryStrings.length) {
            return primaryStrings[autoGGPhrase];
        }
        throw new RuntimeException("An unknown error occurred parsing config. Try deleting .minecraft/config/autogg.toml or contacting the mod authors.");
    }
}

